; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional)
;   buffer.time = time (optional)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas. Each of these
;   buttons or directions is referred to as a "symbol".
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   greater-than (>) - means there must be no other keys pressed or released
;                      between the previous and the current symbol.
;          egs. command = a, >~a   ;press a and release it without having hit
;                                  ;or released any other keys in between
;   You can combine the symbols:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;
;   Note: Successive direction symbols are always expanded in a manner similar
;         to this example:
;           command = F, F
;         is expanded when MUGEN reads it, to become equivalent to:
;           command = F, >~F, >F
;
;   It is recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This makes the command easier
;   to do.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. The default
;   value for this is set in the [Defaults] section below. A typical
;   value is 15.
;
; - buffer.time (optional)
;   Time that the command will be buffered for. If the command is done
;   successfully, then it will be valid for this time. The simplest
;   case is to set this to 1. That means that the command is valid
;   only in the same tick it is performed. With a higher value, such
;   as 3 or 4, you can get a "looser" feel to the command. The result
;   is that combos can become easier to do because you can perform
;   the command early. Attacks just as you regain control (eg. from
;   getting up) also become easier to do. The side effect of this is
;   that the command is continuously asserted, so it will seem as if
;   you had performed the move rapidly in succession during the valid
;   time. To understand this, try setting buffer.time to 30 and hit
;   a fast attack, such as KFM's light punch.
;   The default value for this is set in the [Defaults] section below. 
;   This parameter does not affect hold-only commands (eg. /F). It
;   will be assumed to be 1 for those commands.
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10


;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Default Values |-------------------------------------------------------
[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.
command.time = 15

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.
command.buffer.time = 1

;-| AI |-------------------------------------------------------------
[Command]
name = "CPU1"
command = U,U,U,U,F,F,F,F
time = 1

[Command]
name = "CPU2"
command = U,D,DB,U,F,F,F,F,D
time = 1

[Command]
name = "CPU3"
command = U,D,F,U,F,F,F,F,U,D,U
time = 1

[Command]
name = "CPU4"
command = U,D,F,U,F,F,F,F,U,D,B
time = 1

[Command]
name = "CPU5"
command = B,D,F,U,F,F,F,F,U,D,U
time = 1

[Command]
name = "CPU6"
command = U,D,F,U,B,F,B,F,U,D,U
time = 1

[Command]
name = "CPU7"
command = F,B,F,U,B,F,B,F,U,D,U
time = 1


[Command]
name = "CPU8"
command = F,B,F,U,B,F,B,F,U,D,U,B
time = 1

[Command]
name = "CPU9"
command = F,B,F,U,B,F,B,F,U,D,U,B,U
time = 1

[Command]
name = "CPU10"
command = F,B,F,U,B,F,B,F,U,D,U,B,U,D
time = 1

[Command]
name = "CPU11"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,F
time = 1

[Command]
name = "CPU12"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,B
time = 1

[Command]
name = "CPU13"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,F,DB
time = 1

[Command]
name = "CPU14"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,B,DF
time = 1

[Command]
name = "CPU15"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,B,DF
time = 1

[Command]
name = "CPU16"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,B,DF,F
time = 1

[Command]
name = "CPU17"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,B,DF,F,a
time = 1

;---------------------------------------------------------------------------


[Command]
name = "socorapido01"
command = ~D, $DB, B, x
time = 15

[Command]
name = "socorapido02"
command = ~D, $DB, B, y
time = 15

[Command]
name = "leigan"
command = D, DF, x
time = 15

[Command]
name = "leigan1"
command = D, DF, y
time = 15

[command]
name = "leiganalto"
command = D,F,x
time = 15

[command]
name = "leiganalto1"
command = D,F,y
time = 15

[Command]
name = "chute"
command = ~D, DB, B, a
time = 12

[Command]
name = "chute1"
command = ~D, DB, B, b
time = 12

[Command]
name = "Socoz"
command = ~D, DB, B, x
time= 35


[Command]
name = "Socoz1"
command = ~D, DB, B, y
time= 35

[Command]
name = "HCB_x"
command = x+a
time= 30

[Command]
name = "Empurra"
command = y+b
time = 20

[Command]
name = "leiga2"
command = D, DF, F, D, DF, F,  x
time = 30

[Command]
name = "hold_x";Required (do not remove)
command = /x
time = 1

[Command]
name = "hold_y";Required (do not remove)
command = /y
time = 1

[Command]
name = "charge"
command = /y

[Command]
name = "charge 1"
command = /b

[Command]
name = "Superpulo"
command = ~D, U
time = 5

[Command]
name = "Superpulo"
command = ~D, UF
time = 5

[Command]
name = "Superpulo"
command = ~D, UB
time = 5

[Command]
name = "combo_aga"
command = x+a
time = 25

[Command]
name = "SocoChao"
command = y+b
time = 25

[Command]
name = "hold_s"
command = /z
time = 1


[Command]
Name = "FastComboA"
command =  D, DF, F, D, DF, F, y+b
time = 30


[Command]
Name = "FastComboB"
command =  D, DF, F, D, DF, F, y+b
time = 30

;----------------------especiais--------------------------------

[Command]
name = "qcb_a"
command = ~D, DF, F,D, F, x
time = 25

[Command]
name = "qcb_b"
command = ~D, DF, F,D, F, y
time = 25

[Command]
name = "qcb_c"
command = ~D, DF, F,D, F, x+y
time = 25

[Command]
name = "qcf_2k"
command = ~D, DB, B,D,B, y
time = 30


;===================<HOLD BUTTON>===================
[Command]
name="holda"
command=/a
time=1
[Command]
name="holdb"
command=/b
time=1
[Command]
name="holdc"
command=/c
time=1
[Command]
name="holdx"
command=/x
time=1
[Command]
name="holdy"
command=/y
time=1
[Command]
name="holdz"
command=/z
time=1
[Command]
name="holdstart"
command=/s
time=1


;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery";Required (do not remove)
command = x+y
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;=========================================================================

[state -1]
type = changestate
triggerall = random < 100
triggerall = var(59) = 1
triggerall = stateno != 40
triggerall = statetype != a
trigger1 = (p2movetype = a) && (p2statetype != a) && (enemy, numhelper >= 1)
trigger1 = ctrl = 1
trigger2 = (p2movetype = a) && (p2statetype != a) && (enemy, numproj >= 1)
trigger2 = ctrl = 1
value = 40

[state -1]
type = varset
trigger1 = var(59) = 1
trigger1 = (p2movetype = a) && (p2statetype != a) && (enemy, numproj >= 1)
trigger1 = ctrl = 1
v = 3
value = 1


[State -1, Inteligencia]
type = VarSet
trigger1  = command = "CPU1"
trigger2  = command = "CPU2"
trigger3  = command = "CPU3"
trigger4  = command = "CPU4"
trigger5  = command = "CPU5"
trigger6  = command = "CPU6"
trigger7  = command = "CPU7"
trigger8  = command = "CPU8"
trigger8  = command = "CPU9"
trigger8  = command = "CPU10"
trigger11  = command = "CPU11"
trigger12  = command = "CPU12"
trigger13  = command = "CPU13"
trigger14  = command = "CPU14"
trigger15  = command = "CPU15"
trigger16  = command = "CPU16"
trigger17  = command = "CPU17"
trigger18  = command = "CPU18"
trigger19  = command = "CPU19"
trigger20  = command = "CPU20"
trigger21  = command = "CPU21"
v = 59
value = 1

[state -1]
type = changestate
value = 0
triggerall = var(59) = 1
triggerall = roundstate = 3
trigger1 = statetype != a
trigger1 = ctrl
;===========================================================================

;------------------COMBOS YUSUKE--------------------------------------------
;ground combo 0--------------------------------------------------
[state -1,1]
type = changestate
value = 200
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,20]
trigger1 = random < 50
;trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,20]
trigger2 = random < 50



[state -1]
type = changestate
value = 201
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 200 
trigger1 = movecontact


[state -1]
type = changestate
value = 210
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 201
trigger1 = movecontact


[state -1]
type = changestate
value = 202
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 201
trigger1 = movecontact


[state -1]
type = changestate
value = 211
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 210
trigger1 = movecontact


[state -1]
type = changestate
value = 212
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 211
trigger1 = movecontact
trigger1 = random < 10

[state -1]
type = changestate
value = 213
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 212
trigger1 = movecontact




;ground combo 1--------------------------------------------------

;"CPU5"
[state -1,1]
type = changestate
value = 210
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,20]
trigger1 = random < 50
;trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,20]
trigger2 = random < 50

[state -1]
type = changestate
value = 211
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 210
trigger1 = movecontact


[state -1]
type = changestate
value = 410
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 211
trigger1 = movecontact



[state -1,2]
type = changestate
value = 60
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
;triggerall = power >= 500
;triggerall = time >10
trigger1 = (Movehit)
trigger1 = stateno = 410
trigger1 = movecontact
trigger1 = p2bodydist x < 20
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl


[state -1,2]
type = changestate
value = 600
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != S
trigger1 = stateno = 60
trigger1 = movecontact
trigger1 = p2bodydist x < 20
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl


[state -1,2]
type = changestate
value = 600
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != S
trigger1 = stateno = 60
trigger1 = movecontact
trigger1 = p2bodydist x < 30
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 600
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != S
trigger1 = stateno = 60
trigger1 = movecontact
trigger1 = p2bodydist x < 40
trigger2 = p2bodydist x = [0,50]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 630
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != S
trigger1 = stateno = 600
trigger1 = movecontact
trigger1 = p2bodydist x < 30
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 610
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != S
trigger1 = stateno = 630
trigger1 = movecontact
trigger1 = p2bodydist x < 30
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 640
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != S
trigger1 = stateno = 610
trigger1 = movecontact
trigger1 = p2bodydist x < 30
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 611
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != S
trigger1 = stateno = 640
trigger1 = movecontact
trigger1 = p2bodydist x < 30
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 611
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != S
trigger1 = stateno = 610
trigger1 = movecontact
trigger1 = p2bodydist x < 30
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl


;ground combo 3--------------------------------------------------

;"CPU5"
[state -1,1]
type = changestate
value = 400
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,16]
trigger1 = random < 50
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,16]
trigger2 = random < 50


[state -1]
type = changestate
value = 430
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 400
trigger1 = movecontact


[state -1]
type = changestate
value = 410
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 430 
trigger1 = movecontact


[state -1]
type = changestate
value = 440
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 430
trigger1 = movecontact


;ground combo 2--------------------------------------------------

[state -1,2]
type = changestate
value = 230
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
trigger1 = stateno = 200
trigger1 = movecontact
trigger1 = p2bodydist x < 20
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 250 && enemynear, statetype = l
trigger2 = ctrl

[state -1]
type = changestate
value = 231
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 230
trigger1 = movecontact


[state -1]
type = changestate
value = 232
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 231
trigger1 = movecontact


[state -1]
type = changestate
value = 410
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 230
trigger1 = movecontact


[state -1]
type = changestate
value = 213
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 231 
trigger1 = movecontact

[state -1]
type = changestate
value = 232
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 231
trigger1 = movecontact

;----------------------Golpes para combos------------------------------

[state -1]
type = changestate
value = 800
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 250
triggerall = time >3
trigger1 = (Movehit)
trigger1 = stateno = 203 || stateno = 240 || stateno = 232 
trigger1 = movecontact
trigger1 = random < 50


[state -1]
type = changestate
value = 800
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 250
triggerall = time >3
;trigger1 = (Movehit)
trigger1 = stateno = 410 || stateno = 640 || stateno = 210 || stateno = 203 || stateno = 240 || stateno = 705 || stateno = 706 || stateno = 710
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 705
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 100
triggerall = time >3
trigger1 = (Movehit)
trigger1 = stateno = 611 || stateno = 610 || stateno = 640 || stateno = 712  || stateno = 710 || stateno = 722 || stateno = 70 || stateno = 50 ||  stateno = 706  || stateno = 728 
trigger1 = movecontact
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 705
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 100
triggerall = time >10
;trigger1 = (Movehit)
trigger1 = stateno = 800 || stateno = 804 || stateno = 610 || stateno = 640 || stateno = 712  || stateno = 710 || stateno = 102 || stateno = 115 || stateno = 70 ||  stateno = 706  || stateno = 728 
trigger1 = movecontact
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 706
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 150
triggerall = time >10
;trigger1 = (Movehit)
trigger1 = stateno = 800 || stateno = 804 || stateno = 610 || stateno = 640 || stateno = 712  || stateno = 710 || stateno = 102 || stateno = 115 ||  stateno = 705  || stateno = 728 
trigger1 = movecontact
trigger1 = random < 50


[state -1]
type = changestate
value = 712
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 250
triggerall = time >3
;trigger1 = (Movehit)
trigger1 = stateno = 410 || stateno = 800  || stateno = 804 || stateno = 610 || stateno = 640  || stateno = 240 || stateno = 210
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 712
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 250
triggerall = time >3
trigger1 = (Movehit)
trigger1 =  stateno = 610 || stateno = 640  || stateno = 240 || stateno = 210
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 720
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 250
triggerall = time >3
;trigger1 = (Movehit)
trigger1 = stateno = 611 || stateno = 102 || stateno = 115 || stateno = 70 || stateno = 705 || stateno = 706
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 724
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 250
triggerall = time >3
trigger1 = (Movehit)
trigger1 =  stateno = 611  || stateno = 70 || stateno = 50 || stateno = 705 || stateno = 706
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 735
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 250
triggerall = time >3
trigger1 = (Movehit) 
trigger1 =  stateno = 231  || stateno = 240 || stateno = 210 || stateno = 400 || stateno = 430 || stateno = 212
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 736
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 250
triggerall = time >3
trigger1 = (Movehit)
trigger1 =  stateno = 231  || stateno = 240 || stateno = 210 || stateno = 400  || stateno = 430 || stateno = 212
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 735
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 250
triggerall = time >3
;trigger1 = (Movehit)
trigger1 =  stateno = 232  || stateno = 240 || stateno = 210 || stateno = 400 || stateno = 410 || stateno = 430 || stateno = 212
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 736
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 250
triggerall = time >3
;trigger1 = (Movehit)
trigger1 =  stateno = 232  || stateno = 240 || stateno = 210 || stateno = 400 || stateno = 410  || stateno = 430 || stateno = 440 || stateno = 212
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 700
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 100
triggerall = time >10
;trigger1 = (Movehit)
trigger1 =  stateno = 210  || stateno = 410 || stateno = 440 || stateno = 240 || stateno = 230  || stateno = 231   || stateno = 703
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 703
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 100
triggerall = time >10
;trigger1 = (Movehit)
trigger1 =  stateno = 210  || stateno = 410 || stateno = 440 || stateno = 240 || stateno = 230  || stateno = 231 || stateno = 700
trigger1 = movecontact
trigger1 = random < 50


;--------------------------Combos especiais------------------------------

[state -1]
type = changestate
value = 728
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 1000
triggerall = time >10
;trigger1 = (Movehit)
trigger1 =  stateno = 804  || stateno = 802 || stateno = 722 || stateno = 70  || stateno = 706 || stateno = 710
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 728
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 1000
triggerall = time >10
trigger1 = (Movehit)
trigger1 =  stateno = 804  || stateno = 802 || stateno = 722 || stateno = 70  || stateno = 706 || stateno = 710 
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 730
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 1000
triggerall = time >8
;trigger1 = (Movehit)
trigger1 =  stateno = 804  || stateno = 611 || stateno = 802 || stateno = 721 || stateno = 710 || stateno = 6025; || stateno = 440 
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 730
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 1000
triggerall = time >8
trigger1 = (Movehit)
trigger1 =  stateno = 804  || stateno = 611 || stateno = 802 || stateno = 721 || stateno = 710  || stateno = 6025; || stateno = 440 
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 738
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 2500
triggerall = time >5
;trigger1 = (Movehit)
trigger1 =  stateno = 710 
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 738
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 2500
triggerall = time >5
trigger1 = (Movehit)
trigger1 =  stateno = 611  || stateno = 410 || stateno = 710 ; || stateno = 430 || stateno = 440 
trigger1 = movecontact
trigger1 = random < 50



;-----------------------------------------------------------------------


;CPU1
[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = S && movetype != H
triggerall = power >= 150
trigger1 = ctrl
trigger1 = random <= 5 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 180
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<180,700,700) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<220,700,700)
value = ifelse (p2bodydist x<230,700,700) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<240,700,700)


;-----------------------------------------------------------------------


;CPU2
[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = S && movetype != H
triggerall = power >= 250
trigger1 = ctrl
trigger1 = random <= 5;10 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 195
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<195,703,703) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<225,703,703)
value = ifelse (p2bodydist x<235,703,703) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<245,703,703)


;-----------------------------------------------------------------------


;CPU3
[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = S && movetype != H
triggerall = power >= 250
trigger1 = ctrl
trigger1 = random <= 5;15 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 50
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<50,735,735) ;escolhe o golpe a ser executado


;-----------------------------------------------------------------------


;CPU4
[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = S && movetype != H
triggerall = power >= 250
trigger1 = ctrl
trigger1 = random <=5; 20 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 53
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<53,736,736) ;escolhe o golpe a ser executado


;CPU5
[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = S && movetype != H
triggerall = power >= 250
trigger1 = ctrl
trigger1 = random <= 5;25 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 43
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<43,710,710) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<33,710,710)

;CPU6
[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = A && movetype != H
triggerall = power >= 250
trigger1 = ctrl
trigger1 = random <= 5;30 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 43
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<43,710,710) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<33,710,710)


;CPU7
[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = A && movetype != H
triggerall = power >= 150
trigger1 = ctrl
trigger1 = random <= 5;25 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 23
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<63,705,705) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<23,705,705)



;CPU8
[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = A && movetype != H
triggerall = power >= 250
trigger1 = ctrl
trigger1 = random <= 5;35 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 20
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<20,706,706) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<13,706,706)


;CPU9
[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = A && movetype != H
triggerall = power >= 250
trigger1 = ctrl
trigger1 = random <= 5;40 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 64
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<64,720,720) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<74,720,720)


;CPU10
[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = S && movetype != H
triggerall = power >= 250
trigger1 = ctrl
trigger1 = random <= 5;45 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 44
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<44,800,800) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<34,800,800)


;CPU10
[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = S && movetype != H
triggerall = power >= 1000
trigger1 = ctrl
trigger1 = random <= 5;25 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 51
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<41,728,728) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<51,728,728)



;CPU11
[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = A && movetype != H
triggerall = power >= 1000
trigger1 = ctrl
trigger1 = random <= 5;50 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 51
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<41,728,728) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<51,728,728)


;CPU10
[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = S && movetype != H
triggerall = power >= 1000
trigger1 = ctrl
trigger1 = random <= 5;55 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 75
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<75,730,730) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<65,730,730)


;CPU14
[State -1, powercharge]
type=changestate
value=500
trigger1= var(59)<=0
trigger1= command= "hold_s"; && command="holdy"
trigger1= roundstate=2 && statetype!=A && ctrl
trigger1= power<const(data.power) && power<powermax && !var(20)
trigger1 = random <= 30
trigger1 = p2bodydist x < 50


;CPU15
[State -1, run/dash]
type=changestate
value=ifelse(command="FF",100,105)
trigger1= var(59)<=0
trigger1= command="FF" || command="BB"
trigger1= roundstate=2 && (stateno!=[100,106]) && statetype=S && ctrl



;---------------------------------------------------------------------------

[State -1, Run Fwd]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl


[State -1, correndo frente ar]
type = ChangeState
value = 102
trigger1 = command = "FF"
trigger1 = statetype = A
trigger1 = ctrl

[State -1, correndo traz ar]
type = ChangeState
value = 115
trigger1 = command = "BB"
trigger1 = statetype = A
trigger1 = ctrl


[State -1, Run Back]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl

[State -1:Super pulo]
type = ChangeState
value = 60
triggerall = !var(59)&&command = "Superpulo"
trigger1 = (statetype = S) && (ctrl)

; Carregar Energia 01
[State -1, powercharge]
type=changestate
value=500
trigger1= var(59)<=0
trigger1= command="hold_s"; && command="holdy"
trigger1= roundstate=2 && statetype!=A && ctrl
trigger1= power<const(data.power) && power<powermax && !var(20)


[State -1, Guard Push stand]
type = ChangeState
value = 160
triggerall = power >= 150
triggerall = command = "Empurra" && statetype = S
trigger1 = stateno = [150,153]

[State -1, Guard Push crouch]
type = ChangeState
value = 161
triggerall = power >= 150
triggerall = command = "Empurra" && statetype = C
trigger1 = stateno = [150,153]

[State -1, Guard Push aerial]
type = ChangeState
value = 162
triggerall = power >= 150
triggerall = command = "Empurra" && statetype = A
trigger1 = stateno = [154,155]

;----------------------especiais------------------------------------------

[State -1]
type = ChangeState
value = 738
triggerall = command = "FastComboB"
triggerall = power >= 2500
trigger1 = statetype = S
trigger1 = ctrl

[State -1]
type = ChangeState
value = 738
triggerall = command = "FastComboB"
triggerall = power >= 2500
trigger1 = statetype = A
trigger1 = ctrl


[State -1, Special1]
type = ChangeState
value = 728
triggerall = (StateType != A) && (MoveType != H) && !Var(59)
triggerall = (!IsHelper) && numproj = 0
triggerall = (command = "qcb_a") || (command = "qcb_b") || (command = "qcb_c")
trigger1 = (ctrl = 1)
triggerall = power >= 1000
trigger2 = ((stateno = 200) || (stateno = 210)) && (movecontact >= 1)
trigger3 = ((stateno = 230) || (stateno = 240)) && (movecontact >= 1)
trigger4 = ((StateNo = 250) || (stateno = 220)) && (movecontact >= 1)
trigger5 = ((stateno = 400) || (stateno = 410)) && (movecontact >= 1)
trigger6 = ((stateno = 430) || (stateno = 440)) && (movecontact >= 1)
trigger7 = ((stateno = 450) || (stateno = 420)) && (movecontact >= 1)

[State -1, Special1]
type = ChangeState
value = 728
trigger1 = statetype = A
triggerall = (!IsHelper) && numproj = 0
triggerall = (command = "qcb_a") || (command = "qcb_b") || (command = "qcb_c")
trigger1 = (ctrl = 1)
triggerall = power >= 1000
trigger2 = ((stateno = 200) || (stateno = 210)) && (movecontact >= 1)
trigger3 = ((stateno = 230) || (stateno = 240)) && (movecontact >= 1)
trigger4 = ((StateNo = 250) || (stateno = 220)) && (movecontact >= 1)
trigger5 = ((stateno = 400) || (stateno = 410)) && (movecontact >= 1)
trigger6 = ((stateno = 430) || (stateno = 440)) && (movecontact >= 1)
trigger7 = ((stateno = 450) || (stateno = 420)) && (movecontact >= 1)


[State -1, Hyper1]
type = ChangeState
value = 730
triggerall = power >= 1000
triggerall = (StateType != A) && (MoveType != H) && !Var(59)
triggerall = command = "qcf_2k" && (!IsHelper)
trigger1 = (ctrl = 1)


[State -1, Hyper1]
type = ChangeState
value = 730
triggerall = power >= 1000
triggerall = (StateType != S) && (MoveType != H) && !Var(59)
triggerall = command = "qcf_2k" && (!IsHelper)
trigger1 = (ctrl = 1)


;-------------------------Abilidades---------------------------------------

[State -1]
type = ChangeState
value = 700
triggerall = command = "leigan"
triggerall = power >= 100
trigger1 = statetype = S
trigger1 = ctrl


[State -1]
type = ChangeState
value = 703
triggerall = command = "leigan1"
triggerall = power >= 100
trigger1 = statetype = S
trigger1 = ctrl


[State -1, hadouken]
type = ChangeState
value = 710
triggerall = !var(59)
triggerall = roundstate = 2
triggerall = power >= 250
;triggerall = Command = "NbNV[g1" || Command = "NbNV[g2" || Command = "NbNV[g3"
triggerall = Command = "chute" || Command = "chute1"
triggerall = statetype != A
trigger1 = ctrl || (stateno = 100 && animelemtime(2) > 1) || stateno = 101 || stateno = 40 || (stateno = 52 && anim = 57 && time >= 2)
trigger2 = StateNo = 200
trigger3 = StateNo = 201
trigger4 = StateNo = 210 && (var(16) || time <= 2)
trigger5 = StateNo = 211 && (var(16) || time <= 2 || (var(36) = 1||var(36) = 2))
trigger6 = StateNo = 220 && (var(16) || time <= 2)
trigger7 = StateNo = 221 && (var(16) || time <= 2 || (var(36) = 1||var(36) = 2))
trigger8 = StateNo = 230 && (var(16) || time <= 2)
trigger9 = StateNo = 231 && (var(16) || time <= 2 || (var(36) = 1||var(36) = 2))
trigger10 = StateNo = 240 && (var(16) || time <= 2)
trigger11 = StateNo = 241 && (var(16) || time <= 2 || (var(36) = 1||var(36) = 2))
trigger12 = StateNo = 250 && (var(16) || time <= 2)
trigger13 = StateNo = 251 && (var(16) || time <= 2 || (var(36) = 1||var(36) = 2))
trigger14 = StateNo = 400
trigger15 = StateNo = 410 && (var(16) || time <= 2 || (var(36) = 1||var(36) = 2))
trigger16 = StateNo = 420 && (var(16) || time <= 2)
trigger17 = StateNo = 430
trigger18 = StateNo = 440 && (var(16) || time <= 2 || (var(36) = 1||var(36) = 2))
trigger19 = StateNo = 450 && (var(16) || time <= 2)
trigger20 = stateno = 500 && (var(16) || time <= 2 || ((var(36) = 1||var(36) = 2) && animelemtime(4) < 0))
trigger21 = StateNo = 195 && var(36) && var(16)
trigger22 = (StateNo = [1000,2999]) && var(36) && var(16)
trigger23 = (StateNo = [3000,3199]) && var(5) = 1 && (var(36) = 1||var(36) = 3)
trigger24 = StateNo = 1600 && var(36) = 1
ignorehitpause = 0

[State -1, JWF]
type = ChangeState
value = 800
triggerall = command = "HCB_x" && command != "holddown"
trigger1 = statetype = S && ctrl
triggerall = power >= 250
trigger2 = stateno  = 200 && movecontact = 1
trigger3 = stateno  = 201 && movecontact = 1
trigger4 = stateno  = 202 && movecontact = 1
trigger5 = stateno  = 203 && movecontact = 1
trigger6 = stateno  = 204 && movecontact = 1
trigger7 = stateno  = 205 && movecontact = 1
trigger8 = stateno  = 300 && movecontact = 1
trigger9 = stateno  = 301 && movecontact = 1
trigger10 = stateno = 302 && movecontact = 1
trigger11 = stateno = 303 && movecontact = 1
trigger12 = stateno = 304 && movecontact = 1
trigger13 = stateno = 305 && movecontact = 1


[State -1]
type = ChangeState
value = 735
triggerall = command = "socorapido01"
triggerall = power >= 150
trigger1 = statetype = S
trigger1 = ctrl


[State -1]
type = ChangeState
value = 736
triggerall = command = "socorapido02"
triggerall = power >= 250
trigger1 = statetype = S
trigger1 = ctrl




;---------------GOLPES NORMAIS NO AR -------------------------------------------

;[State -1, leiganalto]    ; leigan ar original
;type = ChangeState
;value =  727
;trigger1 = command = "leiga2"
;triggerall = power >= 1000
;trigger1 = statetype = A
;trigger1 = ctrl



[State -1, leiganalto]    ; leigan ar original
type = ChangeState
value =  705
trigger1 = command = "leiganalto"
triggerall = power >= 100
trigger1 = statetype = A
trigger1 = ctrl
triggerall = power >= 100

[State -1, leiganalto]    ; leigan ar original
type = ChangeState
value =  706
trigger1 = command = "leiganalto1"
triggerall = power >= 150
trigger1 = statetype = A
trigger1 = ctrl
triggerall = power >= 100


[State -1, hadouken]
type = ChangeState
value = 712
triggerall = !var(59)
triggerall = power >= 250
triggerall = roundstate = 2
;triggerall = Command = "NbNV[g1" || Command = "NbNV[g2" || Command = "NbNV[g3"
triggerall = Command = "chute" || Command = "chute1"
triggerall = statetype != S
trigger1 = ctrl || (stateno = 100 && animelemtime(2) > 1) || stateno = 101 || stateno = 40 || (stateno = 52 && anim = 57 && time >= 2)
trigger2 = StateNo = 200
trigger3 = StateNo = 201
trigger4 = StateNo = 210 && (var(16) || time <= 2)
trigger5 = StateNo = 211 && (var(16) || time <= 2 || (var(36) = 1||var(36) = 2))
trigger6 = StateNo = 220 && (var(16) || time <= 2)
trigger7 = StateNo = 221 && (var(16) || time <= 2 || (var(36) = 1||var(36) = 2))
trigger8 = StateNo = 230 && (var(16) || time <= 2)
trigger9 = StateNo = 231 && (var(16) || time <= 2 || (var(36) = 1||var(36) = 2))
trigger10 = StateNo = 240 && (var(16) || time <= 2)
trigger11 = StateNo = 241 && (var(16) || time <= 2 || (var(36) = 1||var(36) = 2))
trigger12 = StateNo = 250 && (var(16) || time <= 2)
trigger13 = StateNo = 251 && (var(16) || time <= 2 || (var(36) = 1||var(36) = 2))
trigger14 = StateNo = 400
trigger15 = StateNo = 410 && (var(16) || time <= 2 || (var(36) = 1||var(36) = 2))
trigger16 = StateNo = 420 && (var(16) || time <= 2)
trigger17 = StateNo = 430
trigger18 = StateNo = 440 && (var(16) || time <= 2 || (var(36) = 1||var(36) = 2))
trigger19 = StateNo = 450 && (var(16) || time <= 2)
trigger20 = stateno = 500 && (var(16) || time <= 2 || ((var(36) = 1||var(36) = 2) && animelemtime(4) < 0))
trigger21 = StateNo = 195 && var(36) && var(16)
trigger22 = (StateNo = [1000,2999]) && var(36) && var(16)
trigger23 = (StateNo = [3000,3199]) && var(5) = 1 && (var(36) = 1||var(36) = 3)
trigger24 = StateNo = 1600 && var(36) = 1
ignorehitpause = 0

[State -1, leiganalto]    ; leigan ar original
type = ChangeState
value =  720
trigger1 = command = "Socoz"
triggerall = power >= 150
trigger1 = statetype = A
trigger1 = ctrl


[State -1, leiganalto]    ; leigan ar original
type = ChangeState
value =  724
trigger1 = command = "Socoz1"
triggerall = power >= 200
trigger1 = statetype = A
trigger1 = ctrl


;---------------------------------------------------------------------------
;Kung Fu Throw
;
;[State -1, Kung Fu Throw]
;type = ChangeState
;value = 800
;triggerall = command = "combo_aga"
;triggerall = statetype = S
;triggerall = ctrl
;triggerall = stateno != 100
;trigger1 = command = "combo_aga";"holdfwd"
;trigger1 = p2bodydist X < 30
;trigger1 = (p2statetype = S) || (p2statetype = C)
;trigger1 = p2movetype != H
;trigger2 = command = "holdback"
;trigger2 = p2bodydist X < 5
;trigger2 = (p2statetype = S) || (p2statetype = C)
;trigger2 = p2movetype != H



;----------------------------combos m------------------------------------

[State -1]
type = ChangeState
value = 230
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "a"
triggerall = stateno = 200
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 240
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "b"
triggerall = stateno = 230
triggerall = movecontact = 1
trigger1 = statetype = S


[State -1]
type = ChangeState
value = 210
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = stateno = 230
triggerall = movecontact = 1
trigger1 = statetype = S


[State -1]
type = ChangeState
value = 240
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "b"
triggerall = stateno = 210
triggerall = movecontact = 1
trigger1 = statetype = S


;---------------------------------------------------------------------------
;Stand Light Punch
;p`
[State -1, Stand Light Punch]
type = ChangeState
value = 200
triggerall = command = "x"
;triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = time > 10

;------------------------------------------------------------------------------

[State -1]
type = ChangeState
value = 201
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 200
triggerall = movecontact = 1
trigger1 = statetype = S


[State -1]
type = ChangeState
value = 210
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = stateno = 201
triggerall = movecontact = 1
trigger1 = statetype = S


[State -1]
type = ChangeState
value = 231
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "a"
triggerall = stateno = 201
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 202
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 231
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 213
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = stateno = 231
triggerall = movecontact = 1
trigger1 = statetype = S

;------------------------------------------------------------------------------

[State -1]
type = ChangeState
value = 210
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 200
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 211
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = stateno = 210
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 410
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = command = "holddown"
triggerall = stateno = 211
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 202
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 211
triggerall = movecontact = 1
trigger1 = statetype = S


[State -1]
type = ChangeState
value = 212
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = stateno = 211
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 231
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "a"
triggerall = stateno = 212
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 213
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = stateno = 212
triggerall = movecontact = 1
trigger1 = statetype = S


[State -1]
type = ChangeState
value = 800
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "combo_aga"
triggerall = stateno = 211
triggerall = movecontact = 1
trigger1 = statetype = S

;------------------------------------------------------------------------------

[State -1]
type = ChangeState
value = 202
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 201
triggerall = movecontact = 1
trigger1 = statetype = S


;---------------------------------------------------------------------------
;Stand Strong Punch
;p`
[State -1, Stand Strong Punch]
type = ChangeState
value = 210
triggerall = command = "y"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 5
trigger3 = (stateno = 230) && time > 6

[State -1]
type = ChangeState
value = 202
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 210
triggerall = movecontact = 1
trigger1 = statetype = S

;---------------------------------------------------------------------------
;Stand Light Kick
;LbN
[State -1, Stand Light Kick]
type = ChangeState
value = 230
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
;trigger2 = (stateno = 200) && time > 7
;trigger3 = (stateno = 230) && time > 9

[State -1]
type = ChangeState
value = 231
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "a"
triggerall = stateno = 230
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 232
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "a"
triggerall = stateno = 231
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 710
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "chute"
triggerall = stateno = 232
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 240
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "b"
triggerall = stateno = 232
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 800
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "combo_aga"
triggerall = stateno = 232
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 200
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 230
triggerall = movecontact = 1
trigger1 = statetype = S

;---------------------------------------------------------------------------
;Standing Strong Kick
;LbN
[State -1, Standing Strong Kick]
type = ChangeState
value = 240
triggerall = command = "b"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 5
trigger3 = (stateno = 230) && time > 6


[State -1]
type = ChangeState
value = 800
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "combo_aga"
triggerall = stateno = 240
triggerall = movecontact = 1
trigger1 = statetype = S

;---------------------------------------------------------------------------
;Taunt
;
[State -1, Taunt]
type = ChangeState
value = 195
triggerall = command = "start"
trigger1 = statetype != A
trigger1 = ctrl

;---------------------------------------------------------------------------
;Crouching Light Punch
;Ⴊݎp`
[State -1, Crouching Light Punch]
type = ChangeState
value = 400
triggerall = command = "x"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

;---------------------------------------------------------------------------
;Crouching Strong Punch
;Ⴊ݋p`
[State -1, Crouching Strong Punch]
type = ChangeState
value = 410
triggerall = command = "y"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 400) || (stateno = 430)
trigger2 = (time > 9) || (movecontact && time > 5)

;---------------------------------------------------------------------------
;Crouching Light Kick
;ႪݎLbN
[State -1, Crouching Light Kick]
type = ChangeState
value = 430
triggerall = command = "a"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 400) || (stateno = 430)
trigger2 = (time > 9) || (movecontact && time > 5)

;---------------------------------------------------------------------------
;Crouching Strong Kick
;Ⴊ݋LbN
[State -1, Crouching Strong Kick]
type = ChangeState
value = 440
triggerall = command = "b"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 400) || (stateno = 430)
trigger2 = (time > 9) || (movecontact && time > 5)

;---------------------------------------------------------------------------
;Jump Light Punch
;󒆎p`
[State -1, Jump Light Punch]
type = ChangeState
value = 600
triggerall = command = "x"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600
trigger2 = statetime >= 15
;trigger3 = stateno = 1350 ;Air blocking

;---------------------------------------------------------------------------
;Jump Strong Punch
[State -1, Jump Strong Punch]
type = ChangeState
value = 610
triggerall = command = "y"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600 || stateno = 630 ;jump_x or jump_a
trigger2 = movecontact
trigger3 = stateno = 1350 ;Air blocking

[State -1]
type = ChangeState
value = 640
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "b"
triggerall = stateno = 610
triggerall = movecontact = 1
trigger1 = statetype = A

[State -1]   ;chute ar forte original
type = ChangeState
value = 611
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "SocoChao"
triggerall = stateno = 610
triggerall = movecontact = 1
trigger1 = statetype = A

[State -1]   ;chute ar forte original
type = ChangeState
value = 611
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "SocoChao"
triggerall = stateno = 640
triggerall = movecontact = 1
trigger1 = statetype = A


[State -1]   ;chute ar forte original
type = ChangeState
value = 727
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "leiga2"
triggerall = stateno = 640
triggerall = movecontact = 1
trigger1 = statetype = A


[State -1]   ;chute ar forte original
type = ChangeState
value = 727
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "leiga2"
triggerall = stateno = 611
triggerall = movecontact = 1
trigger1 = statetype = A

[State -1]   ;chute ar forte original
type = ChangeState
value = 720
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "Socoz"
triggerall = stateno = 611
triggerall = movecontact = 1
trigger1 = statetype = A

[State -1]   ;chute ar forte original
type = ChangeState
value = 724
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "Socoz1"
triggerall = stateno = 611
triggerall = movecontact = 1
trigger1 = statetype = A

;---------------------------------------------------------------------------
;Jump Light Kick
[State -1, Jump Light Kick]
type = ChangeState
value = 630
triggerall = command = "a"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 1350 ;Air blocking

[State -1]
type = ChangeState
value = 630
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "a"
triggerall = stateno = 600
triggerall = movecontact = 1
trigger1 = statetype = A

[State -1]
type = ChangeState
value = 640
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "b"
triggerall = stateno = 630
triggerall = movecontact = 1
trigger1 = statetype = A


;---------------------------------------------------------------------------
;Jump Strong Kick
;󒆋LbN
[State -1, Jump Strong Kick]
type = ChangeState
value = 640
triggerall = command = "b"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600 || stateno = 630 ;jump_x or jump_a
trigger2 = movecontact
trigger3 = stateno = 1350 ;Air blocking


[State -1]
type = ChangeState
value = 610
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = stateno = 640
triggerall = movecontact = 1
trigger1 = statetype = A




[State -1]
type = ChangeState
value = 710
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = Command = "chute" || Command = "chute1"
triggerall = stateno = 610
triggerall = movecontact = 1
trigger1 = statetype = A


[State -1]
type = ChangeState
value = 710
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = Command = "chute" || Command = "chute1"
triggerall = stateno = 640
triggerall = movecontact = 1
trigger1 = statetype = A


[State -1]
type = ChangeState
value = 705
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "leiganalto"
triggerall = stateno = 610
triggerall = movecontact = 1
trigger1 = statetype = A


[State -1]
type = ChangeState
value = 705
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 710
triggerall = movecontact = 1
trigger1 = statetype = A


[State -1]
type = ChangeState
value = 706
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = stateno = 710
triggerall = movecontact = 1
trigger1 = statetype = A

[State -1]
type = ChangeState
value = 705
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 712
triggerall = movecontact = 1
trigger1 = statetype = A


[State -1]
type = ChangeState
value = 706
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = stateno = 712
triggerall = movecontact = 1
trigger1 = statetype = A


[State -1]
type = ChangeState
value = 706
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "leiganalto1"
triggerall = stateno = 640
triggerall = movecontact = 1
trigger1 = statetype = A

[State -1]
type = ChangeState
value = 706
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "leiganalto1"
triggerall = stateno = 610
triggerall = movecontact = 1
trigger1 = statetype = A

[State -1]
type = ChangeState
value = 706
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "leiganalto1"
triggerall = stateno = 611
triggerall = movecontact = 1
trigger1 = statetype = A



[State -1]
type = ChangeState
value = 705
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "leiganalto"
triggerall = stateno = 611
triggerall = movecontact = 1
trigger1 = statetype = A


[State -1]
type = ChangeState
value = 712
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "chute"
triggerall = stateno = 640
triggerall = movecontact = 1
trigger1 = statetype = A

[State -1]
type = ChangeState
value = 712
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "chute"
triggerall = stateno = 610
triggerall = movecontact = 1
trigger1 = statetype = A

[State -1]
type = ChangeState
value = 712
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "chute"
triggerall = stateno = 611
triggerall = movecontact = 1
trigger1 = statetype = A

[State -1]
type = ChangeState
value = 712
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "chute1"
triggerall = stateno = 640
triggerall = movecontact = 1
trigger1 = statetype = A

[State -1]
type = ChangeState
value = 712
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "chute1"
triggerall = stateno = 610
triggerall = movecontact = 1
trigger1 = statetype = A

[State -1]
type = ChangeState
value = 712
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "chute1"
triggerall = stateno = 611
triggerall = movecontact = 1
trigger1 = statetype = A








